/**
* \file: AilAudioOutImpl.h
*
* \version: $Id:$
*
* \release: $Name:$
*
* <brief description>.
* <detailed description>
* \component: CarPlay
*
* \author: J. Michalik / ADIT/SW2 / jmichalik@de.adit-jv.com
*
* \copyright (c) 2016 Advanced Driver Information Technology.
* This code is developed by Advanced Driver Information Technology.
* Copyright of Advanced Driver Information Technology, Bosch, and DENSO.
* All rights reserved.
*
* \see <related items>
*
* \history
*
***********************************************************************/

#ifndef CARPLAY_AILAUDIOOUTIMPL_H
#define CARPLAY_AILAUDIOOUTIMPL_H

#include <atomic>
#include <string>
#include <memory>
#include <carplay_plugin.h>

#include "AudioStreaming.h"

typedef unsigned long int pthread_t;

namespace adit { namespace utility { namespace audio {
class Backend;
class StreamStatistics;
};};};

namespace adit { namespace carplay
{

class AilAudioIn::Impl : public IAudioInAdapter, public adit::utility::audio::Streaming
{
public :
    Impl();
    virtual ~Impl();

    // IAudioOutAdapter implementation
    // no thread-safety required
public:
    virtual bool Initialize(const IConfiguration& inConfig, IAudioInSink& inSink);
    virtual bool Prepare(AudioFormatStruct inFormat, const std::string& inAudioType);
    virtual bool Start();
    virtual void Stop();

    // private section
private:
    const IConfiguration* config;

    IAudioInSink* sink;
    pthread_t processThreadId;

    std::string deviceName;
    uint32_t periodMilli;
    uint32_t periodSamples;
    uint32_t appendEmptyPeriods;
    AudioFormatStruct format;

    std::atomic_bool running;
    std::shared_ptr<adit::utility::audio::Backend> backend;
    bool verboseLogging;
    Samples samples;
    uint64_t sampleNumber;

    bool parseDeviceSettings();
    bool getDeviceName(AudioChannelType inChannel, std::string& outDeviceName);
    int getPeriodMilli(const std::string& inDeviceName, int inSampleRate);
    bool getDeviceSettings(const std::string& inAudioType);

    /* Streaming callbacks */
    void error(const std::string& data) const final;
    void warning(const std::string& data) const final;
    void info(const std::string& data) const final;
    void debug(const std::string& data) const final;
    adit::utility::eLogLevel checkLogLevel() const final;

    adit::utility::audio::AudioState processing(unsigned char *in, unsigned char **out, uint32_t &frames) final;
    void statistics(const adit::utility::audio::StreamStatistics &status) final;
    void eostreaming(const adit::utility::audio::AudioError error) final;
};

} } /* namespace adit { namespace carplay */

#endif /* CARPLAY_AILAUDIOOUTIMPL_H */
